package PROP::SchemaTest;

use strict;
use base qw/Test::Unit::TestCase/;
use PROP::DBH;
use PROP::TestCommon;
use PROP::Schema;

sub new {
    my ($invocant, @args) = @_;
    my $self = $invocant->SUPER::new(@args);

    return $self;
}

sub set_up {
    my ($self) = @_;

    drop_tables();
    create_tables();
}

sub tear_down {
    my ($self) = @_;

    drop_tables();
}

sub test_object_table {
    my ($self) = @_;

    my $table = new PROP::Schema('Foo');

    $self->assert_equals('Foo', $table->get_table_name());

    my @fields = $table->get_field_names();
    $self->assert_equals('foo', $fields[0]);
    $self->assert_equals('bar', $fields[1]);
    $self->assert_equals('baz', $fields[2]);

    $self->assert_equals('foo', $table->get_pk_name());
}

sub test_link_table {
    my ($self) = @_;

    my $table = new PROP::Schema('LinkFooToBiz');

    $self->assert_equals('LinkFooToBiz', $table->get_table_name());

    my @fields = $table->get_field_names();
    $self->assert_equals('foo_id', $fields[0]);
    $self->assert_equals('biz_id', $fields[1]);
    $self->assert_equals('c1',     $fields[2]);
    $self->assert_equals('c2',     $fields[3]);
    $self->assert_equals('c3',     $fields[4]);

    $self->assert_equals('foo_id', $table->get_pk_name()->[0]);
    $self->assert_equals('biz_id', $table->get_pk_name()->[1]);
}

1;

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
