=begin comment

Web API Swagger specification

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: 1.0

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package AsposeCellsCloud::CellsConditionalFormattingsApi;

require 5.6.0;
use strict;
use warnings;
use utf8; 
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use AsposeCellsCloud::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'AsposeCellsCloud::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = AsposeCellsCloud::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# cells_conditional_formattings_delete_worksheet_conditional_formatting
#
# Remove conditional formatting
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_delete_worksheet_conditional_formatting' } = { 
    	summary => 'Remove conditional formatting',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_conditional_formattings_delete_worksheet_conditional_formatting {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_delete_worksheet_conditional_formatting_area
#
# Remove cell area from conditional formatting.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $start_row  (required)
# @param int $start_column  (required)
# @param int $total_rows  (required)
# @param int $total_columns  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'start_row' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'start_column' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'total_rows' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'total_columns' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_delete_worksheet_conditional_formatting_area' } = { 
    	summary => 'Remove cell area from conditional formatting.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_conditional_formattings_delete_worksheet_conditional_formatting_area {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # verify the required parameter 'start_row' is set
    unless (exists $args{'start_row'}) {
      croak("Missing the required parameter 'start_row' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # verify the required parameter 'start_column' is set
    unless (exists $args{'start_column'}) {
      croak("Missing the required parameter 'start_column' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # verify the required parameter 'total_rows' is set
    unless (exists $args{'total_rows'}) {
      croak("Missing the required parameter 'total_rows' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # verify the required parameter 'total_columns' is set
    unless (exists $args{'total_columns'}) {
      croak("Missing the required parameter 'total_columns' when calling cells_conditional_formattings_delete_worksheet_conditional_formatting_area");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/area';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'start_row'}) {
        $query_params->{'startRow'} = $self->{api_client}->to_query_value($args{'start_row'});
    }

    # query params
    if ( exists $args{'start_column'}) {
        $query_params->{'startColumn'} = $self->{api_client}->to_query_value($args{'start_column'});
    }

    # query params
    if ( exists $args{'total_rows'}) {
        $query_params->{'totalRows'} = $self->{api_client}->to_query_value($args{'total_rows'});
    }

    # query params
    if ( exists $args{'total_columns'}) {
        $query_params->{'totalColumns'} = $self->{api_client}->to_query_value($args{'total_columns'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_delete_worksheet_conditional_formattings
#
# Clear all condition formattings
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_delete_worksheet_conditional_formattings' } = { 
    	summary => 'Clear all condition formattings',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_conditional_formattings_delete_worksheet_conditional_formattings {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_delete_worksheet_conditional_formattings");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_delete_worksheet_conditional_formattings");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings';

    my $_method = 'DELETE';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_get_worksheet_conditional_formatting
#
# Get conditional formatting
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_get_worksheet_conditional_formatting' } = { 
    	summary => 'Get conditional formatting',
        params => $params,
        returns => 'ConditionalFormattingResponse',
        };
}
# @return ConditionalFormattingResponse
#
sub cells_conditional_formattings_get_worksheet_conditional_formatting {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_get_worksheet_conditional_formatting");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_get_worksheet_conditional_formatting");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_conditional_formattings_get_worksheet_conditional_formatting");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ConditionalFormattingResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_get_worksheet_conditional_formattings
#
# Get conditional formattings 
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_get_worksheet_conditional_formattings' } = { 
    	summary => 'Get conditional formattings ',
        params => $params,
        returns => 'ConditionalFormattingsResponse',
        };
}
# @return ConditionalFormattingsResponse
#
sub cells_conditional_formattings_get_worksheet_conditional_formattings {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_get_worksheet_conditional_formattings");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_get_worksheet_conditional_formattings");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ConditionalFormattingsResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_put_worksheet_conditional_formatting
#
# Add a condition formatting.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param string $cell_area  (required)
# @param FormatCondition $formatcondition  (optional)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'cell_area' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'formatcondition' => {
        data_type => 'FormatCondition',
        description => '',
        required => '0',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_put_worksheet_conditional_formatting' } = { 
    	summary => 'Add a condition formatting.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_conditional_formattings_put_worksheet_conditional_formatting {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_put_worksheet_conditional_formatting");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_put_worksheet_conditional_formatting");
    }

    # verify the required parameter 'cell_area' is set
    unless (exists $args{'cell_area'}) {
      croak("Missing the required parameter 'cell_area' when calling cells_conditional_formattings_put_worksheet_conditional_formatting");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cell_area'}) {
        $query_params->{'cellArea'} = $self->{api_client}->to_query_value($args{'cell_area'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # body params
    if ( exists $args{'formatcondition'}) {
        $_body_data = $args{'formatcondition'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_put_worksheet_format_condition
#
# Add a format condition.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $cell_area  (required)
# @param string $type  (required)
# @param string $operator_type  (required)
# @param string $formula1  (required)
# @param string $formula2  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'cell_area' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'operator_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'formula1' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'formula2' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_put_worksheet_format_condition' } = { 
    	summary => 'Add a format condition.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_conditional_formattings_put_worksheet_format_condition {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'cell_area' is set
    unless (exists $args{'cell_area'}) {
      croak("Missing the required parameter 'cell_area' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'type' is set
    unless (exists $args{'type'}) {
      croak("Missing the required parameter 'type' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'operator_type' is set
    unless (exists $args{'operator_type'}) {
      croak("Missing the required parameter 'operator_type' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'formula1' is set
    unless (exists $args{'formula1'}) {
      croak("Missing the required parameter 'formula1' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # verify the required parameter 'formula2' is set
    unless (exists $args{'formula2'}) {
      croak("Missing the required parameter 'formula2' when calling cells_conditional_formattings_put_worksheet_format_condition");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cell_area'}) {
        $query_params->{'cellArea'} = $self->{api_client}->to_query_value($args{'cell_area'});
    }

    # query params
    if ( exists $args{'type'}) {
        $query_params->{'type'} = $self->{api_client}->to_query_value($args{'type'});
    }

    # query params
    if ( exists $args{'operator_type'}) {
        $query_params->{'operatorType'} = $self->{api_client}->to_query_value($args{'operator_type'});
    }

    # query params
    if ( exists $args{'formula1'}) {
        $query_params->{'formula1'} = $self->{api_client}->to_query_value($args{'formula1'});
    }

    # query params
    if ( exists $args{'formula2'}) {
        $query_params->{'formula2'} = $self->{api_client}->to_query_value($args{'formula2'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_put_worksheet_format_condition_area
#
# add a cell area for format condition             
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $cell_area  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'cell_area' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_put_worksheet_format_condition_area' } = { 
    	summary => 'add a cell area for format condition             ',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_conditional_formattings_put_worksheet_format_condition_area {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_put_worksheet_format_condition_area");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_put_worksheet_format_condition_area");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_conditional_formattings_put_worksheet_format_condition_area");
    }

    # verify the required parameter 'cell_area' is set
    unless (exists $args{'cell_area'}) {
      croak("Missing the required parameter 'cell_area' when calling cells_conditional_formattings_put_worksheet_format_condition_area");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}/area';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'cell_area'}) {
        $query_params->{'cellArea'} = $self->{api_client}->to_query_value($args{'cell_area'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

#
# cells_conditional_formattings_put_worksheet_format_condition_condition
#
# Add a condition for format condition.
# 
# @param string $name  (required)
# @param string $sheet_name  (required)
# @param int $index  (required)
# @param string $type  (required)
# @param string $operator_type  (required)
# @param string $formula1  (required)
# @param string $formula2  (required)
# @param string $folder  (optional)
# @param string $storage storage name. (optional)
{
    my $params = {
    'name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'sheet_name' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'index' => {
        data_type => 'int',
        description => '',
        required => '1',
    },
    'type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'operator_type' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'formula1' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'formula2' => {
        data_type => 'string',
        description => '',
        required => '1',
    },
    'folder' => {
        data_type => 'string',
        description => '',
        required => '0',
    },
    'storage' => {
        data_type => 'string',
        description => 'storage name.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'cells_conditional_formattings_put_worksheet_format_condition_condition' } = { 
    	summary => 'Add a condition for format condition.',
        params => $params,
        returns => 'SaaSposeResponse',
        };
}
# @return SaaSposeResponse
#
sub cells_conditional_formattings_put_worksheet_format_condition_condition {
    my ($self, %args) = @_;

    # verify the required parameter 'name' is set
    unless (exists $args{'name'}) {
      croak("Missing the required parameter 'name' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'sheet_name' is set
    unless (exists $args{'sheet_name'}) {
      croak("Missing the required parameter 'sheet_name' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'index' is set
    unless (exists $args{'index'}) {
      croak("Missing the required parameter 'index' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'type' is set
    unless (exists $args{'type'}) {
      croak("Missing the required parameter 'type' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'operator_type' is set
    unless (exists $args{'operator_type'}) {
      croak("Missing the required parameter 'operator_type' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'formula1' is set
    unless (exists $args{'formula1'}) {
      croak("Missing the required parameter 'formula1' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # verify the required parameter 'formula2' is set
    unless (exists $args{'formula2'}) {
      croak("Missing the required parameter 'formula2' when calling cells_conditional_formattings_put_worksheet_format_condition_condition");
    }

    # parse inputs
    my $_resource_path = '/cells/{name}/worksheets/{sheetName}/conditionalFormattings/{index}/condition';

    my $_method = 'PUT';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type('application/json');

    # query params
    if ( exists $args{'type'}) {
        $query_params->{'type'} = $self->{api_client}->to_query_value($args{'type'});
    }

    # query params
    if ( exists $args{'operator_type'}) {
        $query_params->{'operatorType'} = $self->{api_client}->to_query_value($args{'operator_type'});
    }

    # query params
    if ( exists $args{'formula1'}) {
        $query_params->{'formula1'} = $self->{api_client}->to_query_value($args{'formula1'});
    }

    # query params
    if ( exists $args{'formula2'}) {
        $query_params->{'formula2'} = $self->{api_client}->to_query_value($args{'formula2'});
    }

    # query params
    if ( exists $args{'folder'}) {
        $query_params->{'folder'} = $self->{api_client}->to_query_value($args{'folder'});
    }

    # query params
    if ( exists $args{'storage'}) {
        $query_params->{'storage'} = $self->{api_client}->to_query_value($args{'storage'});
    }

    # path params
    if ( exists $args{'name'}) {
        my $_base_variable = "{" . "name" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'sheet_name'}) {
        my $_base_variable = "{" . "sheetName" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'sheet_name'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'index'}) {
        my $_base_variable = "{" . "index" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'index'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('SaaSposeResponse', $response);
    return $_response_object;
}

1;
