Article 7817 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:7817
Path: feenix.metronet.com!news.utdallas.edu!wupost!howland.reston.ans.net!xlink.net!gmd.de!dearn!barilvm!kineret.huji.ac.il!wisipc.weizmann.ac.il!
 menora.weizmann.ac.il!dov
Newsgroups: comp.lang.perl
Subject: Need ammunition for Perl vs. C/C++
Message-ID: <1993Nov10.182314.16101@wisipc.weizmann.ac.il>
From: dov@menora.weizmann.ac.il (Dov Grobgeld)
Date: Wed, 10 Nov 1993 18:23:14 GMT
Sender: news@wisipc.weizmann.ac.il (News User)
Organization: Weizmann Institute of Science, Computation Center.
X-Newsreader: Tin 1.1 PL4
Lines: 25

I'm giving a presentation of Perl at my new place of work,
Orbotech, in about a week. They are hard core C/C++ fans and have
far reaching plans of delving deeper into software engineering
tools. Though I know Perl very well, and intuitively everyday in my
coding feel the great advantages of it, I need help with the PR
side of the language. In short I have to convince those who argue
"you can do everything with string classes in C++" that Perl is much
more powerful than you can ever get with such solutions.

My group is a five person strong software group writing software to
support a PostScript RIP, a user interface which at the moment is
written in OpenWindows, and hardware interface.  Obviously, various
system administration tools and installation scripts are also
written.

When my group is convinced, there are more software groups that
may be worked on. :-)

--
                                                        ___   ___
                                                      /  o  \   o \
Dov Grobgeld                                         ( o  o  ) o   |
The Weizmann Institute of Science, Israel             \  o  /o  o /
"Where the tree of wisdom carries oranges"              | |   | |
                                                       _| |_ _| |_


Article 7830 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:7830 comp.lang.misc:1828
Newsgroups: comp.lang.perl,comp.lang.misc
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!magnus.acs.ohio-state.edu!math.ohio-state.edu!cs.utexas.edu!convex!tchrist
From: Tom Christiansen <tchrist@cs.colorado.edu>
Subject: Re: Need ammunition for Perl vs. C/C++
Message-ID: <1993Nov11.125035.3220@convex.com>
Originator: tchrist@convex.convex.com
Sender: usenet@convex.com (news access account)
Nntp-Posting-Host: convex.convex.com
Reply-To: tchrist@cs.Colorado.EDU (Tom Christiansen)
Organization: University of Colorado, Boulder
References: <1993Nov10.182314.16101@wisipc.weizmann.ac.il>
Date: Thu, 11 Nov 1993 12:50:35 GMT
X-Disclaimer: This message was written by a user at CONVEX Computer
              Corp. The opinions expressed are those of the user and
              not necessarily those of CONVEX.
Lines: 81

:-> In comp.lang.perl, dov@menora.weizmann.ac.il (Dov Grobgeld) writes:

:I'm giving a presentation of Perl at my new place of work,
:Orbotech, in about a week. They are hard core C/C++ fans and have
:far reaching plans of delving deeper into software engineering
:tools. Though I know Perl very well, and intuitively everyday in my
:coding feel the great advantages of it, I need help with the PR
:side of the language. In short I have to convince those who argue
:"you can do everything with string classes in C++" that Perl is much
:more powerful than you can ever get with such solutions.
:
:My group is a five person strong software group writing software to
:support a PostScript RIP, a user interface which at the moment is
:written in OpenWindows, and hardware interface.  Obviously, various
:system administration tools and installation scripts are also
:written.
:
:When my group is convinced, there are more software groups that
:may be worked on. :-)

Explain to them that Perl takes care of the two things that no
programmer really wants to deal with: storage allocation and typing.
Declarations are mostly for storage and typing, which is why you don't
generally need them in Perl.

If you want to get right next to the machine, then fine, go ahead and
use C, but you pay a terrible productivity cost for that closeness.  It
takes many times longer to write, the code is much harder to *get*
right, and it's therefor harder to maintain.

As for C++, you pay a terrible price for all that abstraction.  You
have to understand deep and subtle points about the inner workings of
the language before you can hope to use it effectively.  Writing a 
class library is not for the novice.

Time and again, I find people doing things in Perl that they simply could
not do in C or C++, because these people haven't the time, energy,
dedication, and/or background to learn those languages well enough to do
the same things, nor the time to accomplish these tasks even if they did
understand them.  They shouldn't need to go find a priest to intercede
with the machine for them just to get something relatively simple taken
care of.

Perl is an anti-elitist language: it's accessible to those who don't
want to spend all their days in the rarefied stratosphere of
cyberlinguistic theoretical concepts.  You just do it.  It's easy.
You don't have to be computer scientist to use it, nor adopt a mindset
that's foreign to procedurally based languages and thought patterns.

Most of the all this is true for BASIC as well, which is why it remains
popular amongst "normal people" to this very day, despite the cringes it
triggers in academic circles.  The bottom line is that it serves a purpose
and helps people get things done they couldn't otherwise do.  There are
new BASIC scripts written everyday by people without degrees in the
Computer Sciences -- some by those who do, too.  Perl gives you all the
ease of BASIC (no types, no storage worries, formated I/O, etc) without
the accompanying brain-damage, since Perl traces its ancestry back to C
through awk, rather than back to FORTRAN.

The entrenched priesthood of C and C++ may poo-poo the Perl programmers
all they want.  After all, it's the same thing that the assembly
programmers did to *them* before.  It serves to justify and perpetuate
their own existence, and to lock out others from those ranks.  But the
end result here is that because of C, fewer assembly programs need be
written, and because of Perl, fewer C programs need be written.  In both
cases, they still occur -- those languages still have their proper
places -- but such cases certainly need occur far less frequently, and
much more work will be done because of this.

At the price of a few machine cycles, people can leverage their own time
more effectively by using very high level constructs.  While Perl isn't
the only language to let you do this, the familiarity and power it derives
from its synergistic UNIX eclecticism make it a great choice in a UNIX
environment, and in many others as well.

--tom

-- 
    Tom Christiansen      tchrist@cs.colorado.edu       
      "Will Hack Perl for Fine Food and Fun"
        Boulder Colorado  303-444-3212


Article 7835 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:7835 comp.lang.misc:1829
Newsgroups: comp.lang.perl,comp.lang.misc
Path: feenix.metronet.com!news.utdallas.edu!hermes.chpc.utexas.edu!cs.utexas.edu!howland.reston.ans.net!pipex!uknet!zaphod.axion.bt.co.uk!gssec.bt.co.uk!pstevens
From: pstevens@gssec.bt.co.uk (Perdita Stevens)
Subject: Re: Need ammunition for Perl vs. C/C++
In-Reply-To: Tom Christiansen's message of Thu, 11 Nov 1993 12:50:35 GMT
Message-ID: <PSTEVENS.93Nov11132528@cage.gssec.bt.co.uk>
Sender: usenet@gssec.bt.co.uk
Reply-To: Perdita.Stevens@gssec.bt.co.uk
Organization: BT Glasgow Systems and Software Engineering Centre, Scotland.
References: <1993Nov10.182314.16101@wisipc.weizmann.ac.il>
	<1993Nov11.125035.3220@convex.com>
Date: 11 Nov 1993 13:25:27 GMT
Lines: 33

And if you want an anecdote, here is a good one. It isn't quite fair, but
then are the arguments you're facing fair?

Problem: to sort an arbitrarily large file consisting of #-separated
records, on the basis of a date which occurs in one of those fields. This
to be done on a PC with maybe only 1Mb -- so no slurping the file!

Solution 1: around a thousand lines of C++

Solution 2: under a page of Perl

On the typical file-size and set-up expected, the Perl runs around 10 times
faster. Of course the Perl was much faster to develop, too, and more
maintainable. 

I'm not, of course, saying that one couldn't do it *much* faster and more
concisely in C++ than was actually done, by making proper use of class
libraries and using a sensible algorithm. The point is that this is a true
story. And in Perl it was easy. Even the best C++ class library I've ever
met (RogueWave's) wouldn't have made it as easy as it was in Perl. (I wrote
the Perl, not the C++ ;-) )

Actually, I was surprised at how little difference my tweaking to improve
time-efficiency of the Perl made. For example, swapping from regexp
matching to using unpack made no measurable difference. It was already
impressively fast -- I suspect that what this says is that I can't expect
to improve much on the optimisations Larry's already put in...



--
Perdita Stevens
My opinions, not BT's


Article 7842 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:7842 comp.lang.misc:1831
Newsgroups: comp.lang.perl,comp.lang.misc
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!howland.reston.ans.net!sol.ctr.columbia.edu!news.columbia.edu!psinntp!psinntp!ims.com!phoenix!leet
From: leet@ims.com (Lee Thomas)
Subject: Re: Need ammunition for Perl vs. C/C++
In-Reply-To: Tom Christiansen's message of Thu, 11 Nov 1993 12: 50:35 GMT
Message-ID: <LEET.93Nov11093911@ibis.ims.com>
Sender: usenet@ims.com (USENET News Poster)
Organization: Integrated Measurement Systems, Inc.
References: <1993Nov10.182314.16101@wisipc.weizmann.ac.il>
	<1993Nov11.125035.3220@convex.com>
Date: Thu, 11 Nov 1993 17:39:11 GMT
Lines: 51

>>>>> On Thu, 11 Nov 1993 12:50:35 GMT, Tom Christiansen <tchrist@cs.colorado.edu> said:

Tom> :-> In comp.lang.perl, dov@menora.weizmann.ac.il (Dov Grobgeld) writes:

Tom> :I'm giving a presentation of Perl at my new place of work,
Tom> :Orbotech, in about a week. They are hard core C/C++ fans and have
Tom> :far reaching plans of delving deeper into software engineering
Tom> :tools. Though I know Perl very well, and intuitively everyday in my
Tom> :coding feel the great advantages of it, I need help with the PR
Tom> :side of the language. In short I have to convince those who argue
Tom> :"you can do everything with string classes in C++" that Perl is much
Tom> :more powerful than you can ever get with such solutions.

Tom> Time and again, I find people doing things in Perl that they
Tom> simply could not do in C or C++, because these people haven't the
Tom> time, energy, dedication, and/or background to learn those
Tom> languages well enough to do the same things, nor the time to
Tom> accomplish these tasks even if they did understand them.  They
Tom> shouldn't need to go find a priest to intercede with the machine
Tom> for them just to get something relatively simple taken care of.

I'm a software QA engineer, and a Perl user since I first discovered
the language.  Since day one of my career I've been faced with tangled
masses of Bourne shell and csh scripts which inefficiently invoke awk,
sed, grep and other Unix utilities to run automated regression tests,
sometimes mixing in some C executables to achieve process control or IPC.
Rewriting these tools completely in C or C++ is unthinkable, due to
the effort of researching which library call will do what I want (and
due to the fact that most sites I've worked at have not had, e.g., a
regular expression library for C or C++).  Perl allows me to run my
tests quickly, with fewer scripts (thanks, Larry!), and with one
*small* reference manual instead of a shelf-full (thanks, Randal!).

Right now I'm generating data on-the-fly to feed to a program under
test.  I gave up on writing this in C or C++ (and I tried both), just
because it takes too long (as Tom said), not because of lack of
energy, dedication, or background.

--
Lee Thomas,  leet@ims.com
Integrated Measurement Systems
9525 SW Gemini Dr.
Beaverton, Or 97005
(503) 626-7117, ext. 1558

-- 
Lee Thomas,  leet@ims.com               (503) 626-7117, ext. 1558
Integrated Measurement Systems
9525 SW Gemini Dr.
Beaverton, Or 97005



Article 7917 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:7917 comp.lang.misc:1841
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!howland.reston.ans.net!usc!elroy.jpl.nasa.gov!ames!pacbell.com!att-out!rutgers!netnews.upenn.edu!netnews.cc.lehigh.edu!netnews.cc.lehigh.edu!tb06
From: tb06@CS1.CC.Lehigh.EDU (TERRENCE MONROE BRANNON)
Newsgroups: comp.lang.perl,comp.lang.misc
Subject: Re: Need ammunition for Perl vs. C/C++
Message-ID: <TB06.93Nov13173025@CS1.CC.Lehigh.EDU>
Date: 13 Nov 93 22:30:23 GMT
References: <1993Nov10.182314.16101@wisipc.weizmann.ac.il>
	<1993Nov11.125035.3220@convex.com>
Sender: usenet@Lehigh.EDU
Organization: Lehigh University, Bethlehem, PA
Lines: 11
In-Reply-To: tchrist@cs.colorado.edu's message of 11 Nov 93 12: 50:35 GMT
Nntp-Posting-Host: cs1.cc.lehigh.edu


   At the price of a few machine cycles, people can leverage their own time
   more effectively by using very high level constructs.  While Perl isn't

Machine cycles are very important in real time applications.

What bugs me is where exactly does interpretation become slower than
compilation?

--
Terrence Brannon ...... tb06@pl122e.eecs.lehigh.edu


Article 7918 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:7918 comp.lang.misc:1842
Newsgroups: comp.lang.perl,comp.lang.misc
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!magnus.acs.ohio-state.edu!math.ohio-state.edu!cs.utexas.edu!convex!tchrist
From: Tom Christiansen <tchrist@cs.colorado.edu>
Subject: Re: Need ammunition for Perl vs. C/C++
Message-ID: <1993Nov14.005422.22749@convex.com>
Originator: tchrist@convex.convex.com
Sender: usenet@convex.com (news access account)
Nntp-Posting-Host: convex.convex.com
Reply-To: tchrist@cs.Colorado.EDU (Tom Christiansen)
Organization: University of Colorado, Boulder
References: <1993Nov10.182314.16101@wisipc.weizmann.ac.il> <1993Nov11.125035.3220@convex.com> <TB06.93Nov13173025@cs1.cc.lehigh.edu>
Date: Sun, 14 Nov 1993 00:54:22 GMT
X-Disclaimer: This message was written by a user at CONVEX Computer
              Corp. The opinions expressed are those of the user and
              not necessarily those of CONVEX.
Lines: 27

:-> In comp.lang.perl, tb06@CS1.CC.Lehigh.EDU (TERRENCE MONROE BRANNON) writes:
:
:   At the price of a few machine cycles, people can leverage their own time
:   more effectively by using very high level constructs.  While Perl isn't
:
:Machine cycles are very important in real time applications.

Surely.  And equally true is that most appliations are NOT real-time
ones.

:What bugs me is where exactly does interpretation become slower than
:compilation?

Time-to-write (and get right) for me is much more important than
time-to-run in 90% of the applications that I write.  In the other 10%, I
spend some extra time and get within 2 or 3 times C's speed (e=2.71...)
and that's worth it; it's certianly better than going to 10x development
and debugging time.  Maybe I'm just congenitally brain-dmanaged with
respect to low-level type-retentive and allocation-fastidious programming,
or perhaps it's pure self-centeredness that places my time above a mere
machine's.

--tom
-- 
    Tom Christiansen      tchrist@cs.colorado.edu       
      "Will Hack Perl for Fine Food and Fun"
        Boulder Colorado  303-444-3212


Article 7915 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:7915
Path: feenix.metronet.com!news.utdallas.edu!wupost!howland.reston.ans.net!vixen.cso.uiuc.edu!davidw
From: davidw@ncsa.uiuc.edu (David P. Wojtowicz Jr)
Newsgroups: comp.lang.perl
Subject: Re: Need ammunition for Perl vs. C/C++
Date: 13 Nov 1993 23:42:12 GMT
Organization: NCSA-University of Illinois at Urbana-Champaign
Lines: 70
Message-ID: <2c3rck$pro@vixen.cso.uiuc.edu>
References: <1993Nov10.182314.16101@wisipc.weizmann.ac.il>
NNTP-Posting-Host: braque.ncsa.uiuc.edu

In article <1993Nov10.182314.16101@wisipc.weizmann.ac.il> dov@menora.weizmann.ac.il (Dov Grobgeld) writes:
>I'm giving a presentation of Perl at my new place of work,
>Orbotech, in about a week. They are hard core C/C++ fans and have
>far reaching plans of delving deeper into software engineering
>tools. Though I know Perl very well, and intuitively everyday in my
>coding feel the great advantages of it, I need help with the PR
>side of the language. In short I have to convince those who argue
>"you can do everything with string classes in C++" that Perl is much
>more powerful than you can ever get with such solutions.
>
>

I'm very much a C/C++ type, but I recently discovered Perl and now
am writing gobs of stuff in it, and getting alot more accomplished
in the same amount of time.

There are many advantages to using Perl.  One of the big ones for me
I'm finding is that it makes it much faster to do incremental testing.
What I mean by this is that, often when you're working on a complex
piece of code you have to make a few changes or additions, and then
test the code, find it's still not quite right, go back and change
again, and keep on repeating this cycle.  Example: 

I have some big pieces of C++ code... with all the nested #includes
and lots of libraries to link, it can take over 2 minutes to compile
and link for each test...  much too long to wait.  Now what I've done
is to isolate all the stuff that  has to be done in C++ (calls to
graphics libraries, etc.)  and put an interface on top of that that
accepts commands in the form of strings that in turn call the various
C++ functions and returns strings containing any return information.
When the program starts it spawns a copy of perl running and talks to
it via a pipe.   Now I can put all the higher level control in perl
and have it just pass on the lower level commands thru the pipe to
the C++ program.  Now that the C++ part is fairly stable I rarely
have to recompile it anymore and just keep modifying the perl part,
which of course compiles rapidly.   Now it only takes 10 seconds to
test a change I've just made.

Also, I've found that I used to waste lots of time figuring out why
my C++ programs were core dumping, sometimes taking days to find the
place where I was writing off the end of an array and causing problems
in some other unrelated part of the code.  C/C++ puts lots of responsibility
on the programmer for keeping track of memory and pointers.  Perl relieves
you of this burden and I rarely see the dreaded, stress causing
"abort due to SEGV, core dumped" messages anymore.

Sure, Perl is going to be slower than a well written C++ program, but
in many applications the time difference is insignificant.  When
parsing a single line of user input for example, it doesn't really
matter if its going to take .01 seconds with the C++ program or .1
seconds in Perl...the difference is too small for the user to even
notice.  And for programs that generate reports and such, I'm willing
for it to take a bit longer to run if its going to save me days of
programming in C++.

Obviously perl is not good for some things, like doing any significant
amount of math or calling graphics libraries, etc. but then, it was
never meant to be.  Use the right tool for the job.


--------------------------------------------------------
 David Wojtowicz
 National Center for Supercomputing Applications (NCSA)
 University of Illinois at Urbana-Champaign
 email: davidw@uiuc.edu  phone: (217)244-1982
--------------------------------------------------------






