Article: 1784 of comp.lang.perl
Xref: feenix.metronet.com comp.lang.perl:1784
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.utdallas.edu!tamsun.tamu.edu!cs.utexas.edu!zaphod.mps.ohio-state.edu!howland.reston.ans.net!agate!ames!sgi!wdl1!wdl39!mab
From: mab@wdl39.wdl.loral.com (Mark A Biggar)
#Subject: Re: better way to grep
Message-ID: <1993Mar24.183956.14132@wdl.loral.com>
Keywords: grep
Sender: news@wdl.loral.com
Organization: Loral Western Development Labs
References: <1993Mar23.221922.14089@fnbc.com>
Date: Wed, 24 Mar 1993 18:39:56 GMT
Lines: 35

In article <1993Mar23.221922.14089@fnbc.com> jja@fnbc.com (Joseph Alotta) writes:
>can one of you gurus please look at my code and tell me
>a better way to implement this.
>since my files tend to be large with lots of symbols,
>i'm concerned with greping twice for the same things, as in:
>		@subset = grep(/$symbol/, @records);
>		@records = grep(!/$symbol/,@records);
>is there a way to do it in one step?  maybe there's another
>way to do the entire, perhaps to sort it first.

Try:

@subset = ();
@record = grep((/$symbol/?(push(@subset, $_),0):1), @records);

Note that by using more complicated ?: expressions you could split
an array into 3 or more sets just as easy.  For example, to split an array of
words into sets starting with [A-I], [J-P], and [R-Z] (like for setting 
up registration lines at a conference) you could use the following:

@a2i = ();
@j2p = ();
@r2z = ();
@rejects = grep((/^[A-I]/?(push(@a2i, $_),0):
                (/^[J-P]/?(push(@j2p, $_),0):
		(/^[R-Z]/?(push(@r2z, $_),0):1))), @names);

Hey, Larry and Randal, this looks like something that should go in
chapter 5 of the next edition of the Perl book.

--
Perl's Maternal Uncle
Mark Biggar
mab@wdl1.wdl.loral.com



