NAME
====

Pod::To::HTML

AUTHOR
======

Patrick Spek <p.spek@tyil.work>

VERSION
=======

0.0.0

Synopsis
========

    raku --doc=HTML::Section <document>

Description
===========

Convert a Pod6 document to HTMLWell, just a *section* of it, really.

Installation
============

Through `zef`
-------------

[zef](https://github.com/ugexe/zef) is the standard distribution manager for [Raku](https://raku.org). If you're using an end-user distribution like [Rakudo Star](https://rakudo.org/files/star), it will be installed for you by default.

`zef` will install the latest available version from [CPAN](http://www.cpan.org/modules/index.html).

```sh
zef install Pod::To::HTML::Section
```

From a downloaded distribution
------------------------------

All official releases are also made available on my [personal distribution server](https://dist.tyil.nl/raku/modules/). These can be installed from the URL directly.

```sh
zef install https://dist.tyil.nl/raku/modules/Pod-To-HTML-Section-0.1.0.tar.gz
```

Alternatively, you can download the distribution first, and then install that copy with `zef`.

```sh
wget https://dist.tyil.nl/raku/modules/Pod-To-HTML-Section-0.1.0.tar.gz
zef install ./Pod-To-HTML-Section-0.1.0.tar.gz
```

Contributing
============

Reporting bugs or other feedback
--------------------------------

Any bugs or other feedback can be sent to my email address. I generally try to respond to all mail within 24 hours.

Proposing code patches
----------------------

Code patches can also be sent in through email. If you need help to send git patches through email, you may want to read up on [git-send-email.io](https://git-send-email.io/).

### Testing

If you're working on a code patch, you will more than likely want to test your own changes to see if they're solving your issue. The easiest way to get the HTML out on your terminal is to specify your development copy with `-I` to give it priority, and using `raku --doc` as usual.

    raku -Ilib --doc=HTML::Section <document>

However, this may be hard to read for most purposes. If you have `xmllint` and `tidy` available on your system, you can use these tools in conjuction with the `raku --doc` command to format the HTML.

    raku -Ilib --doc=HTML::Section <document> \
       | xmllint --html - 2>/dev/null \
       | tidy --indent yes 2>/dev/null

License
=======

This module is distributed under the terms of the GNUGNU's Not Unix AGPLAferro General Public License, version 3.0.

