#!/usr/bin/perl
# ǧ
#./lwp_flash_lite_map_docomo.pl | ./make_map.pl
#
# 
#./lwp_flash_lite_map_docomo.pl | ./make_map.pl -o

use strict;
use warnings;
use Data::Dumper;
use FindBin;
use YAML;
use File::Spec;

do_task(@ARGV);

sub do_task {

    my $yaml = YAML::Load(join "", <STDIN>);
    my $overwrite = $ARGV[0] && $ARGV[0] eq '-o';
    output_code($yaml, $overwrite);
}

sub output_code {
    my($map, $overwrite) = @_;
    my $fh;
    if ($overwrite) {
        open $fh, ">",  File::Spec->catfile($FindBin::Bin, qw/.. lib HTTP MobileAgent Flash DoCoMoFlashMap.pm/) or die $!;
        select $fh;
    }
    $Data::Dumper::Indent = 1;
    $Data::Dumper::Terse  = 1;
    printf <<'TEMPLATE', $0, Data::Dumper->Dump([ $map ]);
package HTTP::MobileAgent::Flash::DoCoMoFlashMap;
# -------------------------------------------------------------------------
# This file is autogenerated by %s
# in HTTP-MobileAgent-Flash distribution
# -------------------------------------------------------------------------
use strict;
use warnings;

require Exporter;
use base qw(Exporter);
use vars qw(@EXPORT_OK $FLASH_MAP);
@EXPORT_OK = qw($FLASH_MAP);


BEGIN {
    if ($ENV{DOCOMO_FLASH_MAP}) {
        eval q{
            require YAML::Syck;
            $FLASH_MAP = YAML::Syck::LoadFile($ENV{DOCOMO_FLASH_MAP});
        };
        if ($@) {
            eval q{
                require YAML;
                $FLASH_MAP = YAML::LoadFile($ENV{DOCOMO_FLASH_MAP});
            };
        }
        warn "using normal hash map: $@" if $@;
    }
}

$FLASH_MAP ||= %s;

1;
TEMPLATE
    ;
    if ($overwrite) {
        close $fh;
    }
}

1;
