use v6.c;

use experimental :pack;

use Test;

use OLE::Storage_Lite::Utils;

plan 297;

my $testdata = q:to[_END_];
0-0-0-1-0-70        00803ED5DEB19D01  1970-01-01T00:00:00Z
1-0-0-1-0-70        8016D7D5DEB19D01  1970-01-01T00:00:01Z
15-28-6-16-1-70     80E925B13AD69D01  1970-02-16T06:28:15Z
3-49-8-11-11-70     80E9A5BB79C09E01  1970-12-11T08:49:03Z
3-17-0-1-2-71       80E925760FFF9E01  1971-03-01T00:17:03Z
51-49-14-9-7-71     80516A100D7E9F01  1971-08-09T14:49:51Z
51-45-13-4-6-72     8051EACB5481A001  1972-07-04T13:45:51Z
35-37-3-9-11-73     80E9A578F91BA201  1973-12-09T03:37:35Z
59-35-18-3-5-75     80516A9B95C5A301  1975-06-03T18:35:59Z
31-52-3-31-9-75     80E9250AF93AA401  1975-10-31T03:52:31Z
43-27-17-20-4-76    80516A6326DAA401  1976-05-20T17:27:43Z
31-8-9-3-5-76       80516AF8E0E4A401  1976-06-03T09:08:31Z
7-22-22-7-5-76      80516A7F74E8A401  1976-06-07T22:22:07Z
51-25-0-29-5-77     8051EABBD717A601  1977-06-29T00:25:51Z
7-30-16-20-3-79     80516AC9FF1EA801  1979-04-20T16:30:07Z
23-46-3-8-3-80      80516ABEC134A901  1980-04-08T03:46:23Z
59-3-10-31-2-81     8051EAA37E4DAA01  1981-03-31T10:03:59Z
59-15-12-22-1-84    80E9A55DF28CAD01  1984-02-22T12:15:59Z
31-8-17-13-4-84     8051EAA6C1CCAD01  1984-05-13T17:08:31Z
19-41-22-10-3-85    8051EA25D3D1AE01  1985-04-10T22:41:19Z
47-4-14-10-1-86     80E9A5AFFFC1AF01  1986-02-10T14:04:47Z
7-14-3-9-2-86       80E92543DCD6AF01  1986-03-09T03:14:07Z
35-1-11-28-8-86     8051EA32A276B001  1986-09-28T11:01:35Z
7-22-13-12-1-88     80E925002F01B201  1988-02-12T13:22:07Z
51-1-9-26-11-88     80E9A553EDFAB201  1988-12-26T09:01:51Z
7-30-23-17-0-90     80E925BD812BB401  1990-01-17T23:30:07Z
39-58-20-30-0-90    80E9A5BBA335B401  1990-01-30T20:58:39Z
47-52-10-23-2-90    80E9A5B52B5EB401  1990-03-23T10:52:47Z
51-21-6-12-11-91    80E925124B4CB601  1991-12-12T06:21:51Z
23-50-4-20-4-93     8051EA45CAE8B701  1993-05-20T04:50:23Z
43-3-18-14-11-93    80E9A58FAB8CB801  1993-12-14T18:03:43Z
11-3-21-21-5-96     8051EA0DB55FBB01  1996-06-21T21:03:11Z
47-28-13-30-6-96    80516A091B7EBB01  1996-07-30T13:28:47Z
55-34-6-24-9-96     8051EA7775C1BB01  1996-10-24T06:34:55Z
27-39-12-16-1-97    80E92572061CBC01  1997-02-16T12:39:27Z
51-53-23-8-3-98     80516A944963BD01  1998-04-08T23:53:51Z
31-0-15-15-9-98     80516A8D4CF8BD01  1998-10-15T15:00:31Z
51-53-23-2-8-99     8051EA679EF5BE01  1999-09-02T23:53:51Z
11-27-18-6-11-99    80E9A5821740BF01  1999-12-06T18:27:11Z
0-0-0-28-1-100      00C062C17E81BF01  2000-02-28T00:00:00Z
59-59-23-28-1-100   80E933EB4782BF01  2000-02-28T23:59:59Z
0-0-0-29-1-100      0080CCEB4782BF01  2000-02-29T00:00:00Z
23-30-7-27-2-100    8051EA4FBE97BF01  2000-03-27T07:30:23Z
59-55-15-22-9-100   8051EA91403CC001  2000-10-22T15:55:59Z
0-0-0-28-1-101      0040936419A1C001  2001-02-28T00:00:00Z
59-59-23-28-1-101   8069648EE2A1C001  2001-02-28T23:59:59Z
0-0-0-1-2-101       0000FD8EE2A1C001  2001-03-01T00:00:00Z
27-39-5-20-9-101    8051EA942959C101  2001-10-20T05:39:27Z
11-19-1-3-8-102     80516AE8E752C201  2002-09-03T01:19:11Z
15-32-7-13-10-102   80E9A5C9E68AC201  2002-11-13T07:32:15Z
19-21-17-23-9-103   80516A128A99C301  2003-10-23T17:21:19Z
31-24-4-12-1-104    80E9251C20F1C301  2004-02-12T04:24:31Z
0-0-0-28-1-104      0080E7CE8DFDC301  2004-02-28T00:00:00Z
59-59-23-28-1-104   80A9B8F856FEC301  2004-02-28T23:59:59Z
0-0-0-29-1-104      004051F956FEC301  2004-02-29T00:00:00Z
47-52-11-29-2-104   80516A5A8415C401  2004-03-29T11:52:47Z
3-17-0-17-2-106     80E9A51D5849C601  2006-03-17T00:17:03Z
31-0-7-7-3-106      80516AF5105AC601  2006-04-07T07:00:31Z
55-58-20-6-4-106    8051EAE24F71C601  2006-05-06T20:58:55Z
39-58-5-9-5-106     8051EAC0898BC601  2006-06-09T05:58:39Z
39-14-2-1-6-107     8051EA9385BBC701  2007-07-01T02:14:39Z
31-56-21-20-7-107   80516AF774E3C701  2007-08-20T21:56:31Z
1-47-1-7-4-108      80D8233EE4AFC801  2008-05-07T01:47:01Z
15-24-5-17-10-108   80E925BB7448C901  2008-11-17T05:24:15Z
35-25-0-21-10-108   80E9A5AB6F4BC901  2008-11-21T00:25:35Z
35-29-9-2-11-108    80E9257D6054C901  2008-12-02T09:29:35Z
59-59-23-31-11-108  80A90EE3A36BC901  2008-12-31T23:59:59Z
39-42-9-1-7-109     80516A688C12CA01  2009-08-01T09:42:39Z
11-39-21-1-10-109   80E9A5BF3B5BCA01  2009-11-01T21:39:11Z
31-36-0-14-3-110    8051EA866ADBCA01  2010-04-14T00:36:31Z
59-23-6-3-10-110    80E925B31F7BCB01  2010-11-03T06:23:59Z
19-49-7-14-0-111    80E9A58CBFB3CB01  2011-01-14T07:49:19Z
23-46-2-9-1-111     80E9A58903C8CB01  2011-02-09T02:46:23Z
3-37-14-8-5-112     80516A2B8445CD01  2012-06-08T14:37:03Z
55-30-13-1-8-112    80516A034688CD01  2012-09-01T13:30:55Z
59-31-17-8-9-112    8051EAD17AA5CD01  2012-10-08T17:31:59Z
7-38-9-2-0-113      80E9A5DECCE8CD01  2013-01-02T09:38:07Z
47-4-6-19-2-113     80E9A5A86724CE01  2013-03-19T06:04:47Z
19-33-19-12-1-115   80E925C1FA46D001  2015-02-12T19:33:19Z
35-5-20-11-7-117    80516A31DD12D301  2017-08-11T20:05:35Z
59-19-6-2-9-118     8051EAF1175AD401  2018-10-02T06:19:59Z
39-38-0-14-4-119    80516A5FED09D501  2019-05-14T00:38:39Z
15-44-11-13-9-119   8051EA89BB81D501  2019-10-13T11:44:15Z
39-54-3-16-11-119   80E9258AC4B3D501  2019-12-16T03:54:39Z
7-26-14-8-10-120    80E9A518DBB5D601  2020-11-08T14:26:07Z
23-10-9-8-1-121     80E9253BFAFDD601  2021-02-08T09:10:23Z
23-58-6-1-5-122     8051EAFB8475D801  2022-06-01T06:58:23Z
3-49-1-12-3-123     80516AF5E06CD901  2023-04-12T01:49:03Z
15-0-15-24-11-125   80E9A502E674DC01  2025-12-24T15:00:15Z
31-28-22-5-6-127    80516A149F2BDE01  2027-07-05T22:28:31Z
47-4-23-12-8-127    8051EA93DC61DE01  2027-09-12T23:04:47Z
23-30-15-21-9-127   80516A8F4280DE01  2027-10-21T15:30:23Z
3-9-7-28-6-128      80516A14CC5CDF01  2028-07-28T07:09:03Z
39-22-20-1-7-128    80516A9B5F60DF01  2028-08-01T20:22:39Z
19-33-12-8-7-129    80516AAC6F84E001  2029-08-08T12:33:19Z
51-5-10-9-11-132    80E925084042E401  2032-12-09T10:05:51Z
43-27-9-29-3-134    80516A89D8CFE501  2034-04-29T09:27:43Z
7-42-11-2-4-137     8051EA63842FE901  2037-05-02T11:42:07Z
59-27-7-21-11-137   80E9A57D78E6E901  2037-12-21T07:27:59Z
_END_

for $testdata.lines -> $line {
  next if $line ~~ m{ ^ \s* '#' };

  my ( $expected_local, $expected_ole, $iso_timestamp ) =
    split( /\s+/, $line, 3 );

  my @expected_local = map { +$_ }, split( /\-/, $expected_local );
  my $got_oletimeObj = LocalDateObject2OLE(
    DateTime.new(
      second => @expected_local[0],
      minute => @expected_local[1],
      hour   => @expected_local[2],
      day    => @expected_local[3],
      month  => @expected_local[4] + 1,
      year   => @expected_local[5] + 1900,
    )
  );
  $got_oletimeObj = uc $got_oletimeObj.unpack( "H*" );

  is $got_oletimeObj,
     $expected_ole,
     "LocalDateObj2OLE: $iso_timestamp";

  # Test LocalDate2OLE
  $expected_ole = pack 'H*', $expected_ole;

  my $got_lt      = OLEDate2LocalObject( $expected_ole );
  $expected_local = join '-', @$expected_local;

  is $got_lt, DateTime.new(
    second => @expected_local[0],
    minute => @expected_local[1],
    hour   => @expected_local[2],
    day    => @expected_local[3],
    month  => @expected_local[4] + 1,
    year   => @expected_local[5] + 1900,
  ), "OLEDate2LocalObject: $iso_timestamp";

  is $got_lt, $iso_timestamp, "OLE check: $iso_timestamp";
}

done-testing;
