# Unit tests for WARC::Index module				# -*- CPerl -*-

use strict;
use warnings;

use Test::More tests => 4 + (4 + 6);

BEGIN { use_ok('WARC::Index')
	  or BAIL_OUT "WARC::Index failed to load" }

BEGIN {
  my $fail = 0;
  eval q{use WARC::Index v9999.1.2.3; $fail = 1};
  ok($fail == 0
     && $@ =~ m/WARC.* version v9999.*required--this is only version/,
     'WARC::Index version check')
}

my $fail = 0;

eval { my $index = attach WARC::Index (); $fail = 1 };
ok($fail == 0 && $@ =~ m/abstract base class/, 'attaching base class dies');

{
  my $index = bless {}, 'WARC::Index'; # make a fake index object
  $fail = 0;

  eval { $index->search(bogus => 1); $fail = 1 };
  ok($fail == 0 && $@ =~ m/abstract base class/, 'search in base class dies');
}

note('*' x 60);

# Index registration tests
{
  package WARC::Index::_TestMock::Bogus;

  use Test::More;

  {
    my $fail = 0;
    eval {WARC::Index::register(filename => qr/bogus/); $fail = 1;};
    ok($fail == 0 && $@ =~ m/must subclass WARC::Index/,
       'registering bogus index module dies');
  }
}
{
  package WARC::Index::_TestMock::I1;

  use Test::More;

  our @ISA = qw(WARC::Index);

  {
    my $fail = 0;
    eval {WARC::Index::register(); $fail = 1;};
    ok($fail == 0 && $@ =~ m/must.*filename pattern/,
       'invalid index registration dies (1)');

    my $warn_count = 0;
    local $SIG{__WARN__} = sub {$warn_count++};
    $fail = 0;
    eval {WARC::Index::register(qr/[.]idx$/); $fail = 1;};
    ok($fail == 0 && $@ =~ m/must.*filename pattern/,
       'invalid index registration dies (2)');
    is($warn_count, 1,	'one warning produced during invalid call');
  }

  WARC::Index::register(filename => qr/[.]idx1$/);
}
{
  package WARC::Index::_TestMock::I2;

  our @ISA = qw(WARC::Index);

  WARC::Index::register(filename => qr/[.]idx2$/);
  WARC::Index::register(filename => qr/[.]idx2a$/);
  WARC::Index::register(filename => qr/[.]idx2b$/);
}
{
  package WARC::Index::_TestMock::IXa;

  our @ISA = qw(WARC::Index);

  WARC::Index::register(filename => qr/[.]idx.a$/);
}

is(WARC::Index::find_handler('test.idx1'), 'WARC::Index::_TestMock::I1',
   'find_handler for "test.idx1" finds I1');
is(WARC::Index::find_handler('test.idx2'), 'WARC::Index::_TestMock::I2',
   'find_handler for "test.idx2" finds I2');
like(WARC::Index::find_handler('test.idx2a'),
     qr/WARC::Index::_TestMock::I(?:2|Xa)/,
     'find_handler for "test.idx2a" finds I2 or IXa');
is(WARC::Index::find_handler('test.idx2b'), 'WARC::Index::_TestMock::I2',
   'find_handler for "test.idx2b" finds I2');
is(WARC::Index::find_handler('test.idx3a'), 'WARC::Index::_TestMock::IXa',
   'find_handler for "test.idx3a" finds IXa');
ok((not defined WARC::Index::find_handler('test.idx')),
   'find_handler returns undef for "test.idx"');
