# Copyright 2020, Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package Google::Ads::GoogleAds::V22::Enums::ExternalConversionSourceEnum;

use strict;
use warnings;

use Const::Exporter enums => [
  UNSPECIFIED                      => "UNSPECIFIED",
  UNKNOWN                          => "UNKNOWN",
  WEBPAGE                          => "WEBPAGE",
  ANALYTICS                        => "ANALYTICS",
  UPLOAD                           => "UPLOAD",
  AD_CALL_METRICS                  => "AD_CALL_METRICS",
  WEBSITE_CALL_METRICS             => "WEBSITE_CALL_METRICS",
  STORE_VISITS                     => "STORE_VISITS",
  ANDROID_IN_APP                   => "ANDROID_IN_APP",
  IOS_IN_APP                       => "IOS_IN_APP",
  IOS_FIRST_OPEN                   => "IOS_FIRST_OPEN",
  APP_UNSPECIFIED                  => "APP_UNSPECIFIED",
  ANDROID_FIRST_OPEN               => "ANDROID_FIRST_OPEN",
  UPLOAD_CALLS                     => "UPLOAD_CALLS",
  FIREBASE                         => "FIREBASE",
  CLICK_TO_CALL                    => "CLICK_TO_CALL",
  SALESFORCE                       => "SALESFORCE",
  STORE_SALES_CRM                  => "STORE_SALES_CRM",
  STORE_SALES_PAYMENT_NETWORK      => "STORE_SALES_PAYMENT_NETWORK",
  GOOGLE_PLAY                      => "GOOGLE_PLAY",
  THIRD_PARTY_APP_ANALYTICS        => "THIRD_PARTY_APP_ANALYTICS",
  GOOGLE_ATTRIBUTION               => "GOOGLE_ATTRIBUTION",
  STORE_SALES_DIRECT_UPLOAD        => "STORE_SALES_DIRECT_UPLOAD",
  STORE_SALES                      => "STORE_SALES",
  SEARCH_ADS_360                   => "SEARCH_ADS_360",
  GOOGLE_HOSTED                    => "GOOGLE_HOSTED",
  FLOODLIGHT                       => "FLOODLIGHT",
  ANALYTICS_SEARCH_ADS_360         => "ANALYTICS_SEARCH_ADS_360",
  FIREBASE_SEARCH_ADS_360          => "FIREBASE_SEARCH_ADS_360",
  DISPLAY_AND_VIDEO_360_FLOODLIGHT => "DISPLAY_AND_VIDEO_360_FLOODLIGHT"
];

1;
